/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.unity3d.player.AudioVolumeHandler;
import com.unity3d.player.C;
import com.unity3d.player.Camera2Wrapper;
import com.unity3d.player.GoogleARCoreApi;
import com.unity3d.player.HFPStatus;
import com.unity3d.player.I;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.J;
import com.unity3d.player.MultiWindowSupport;
import com.unity3d.player.NativeLoader;
import com.unity3d.player.NetworkConnectivity;
import com.unity3d.player.NetworkConnectivityNougat;
import com.unity3d.player.OrientationLockListener;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.U;
import com.unity3d.player.UnityPermissions;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.u;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class UnityPlayer
extends FrameLayout
implements IUnityPlayerLifecycleEvents {
    public static Activity currentActivity;
    public static Context currentContext;
    private static final int RUN_STATE_CHANGED_MSG_CODE = 2269;
    private static final String SPLASH_ENABLE_METADATA_NAME = "unity.splash-enable";
    private static final String SPLASH_MODE_METADATA_NAME = "unity.splash-mode";
    private static final String LAUNCH_FULLSCREEN = "unity.launch-fullscreen";
    private static final String ARCORE_ENABLE_METADATA_NAME = "unity.arcore-enable";
    private static final String AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME = "unity.auto-report-fully-drawn";
    Handler mHandler;
    private int mInitialScreenOrientation;
    private boolean mMainDisplayOverride;
    private boolean mIsFullscreen;
    private J mState;
    private final ConcurrentLinkedQueue m_Events;
    private OrientationEventListener mOrientationListener;
    private int mNaturalOrientation;
    private Configuration prevConfig;
    F m_MainThread;
    private boolean m_AddPhoneCallListener;
    private D m_PhoneCallListener;
    private TelephonyManager m_TelephonyManager;
    private ClipboardManager m_ClipboardManager;
    private com.unity3d.player.C m_SplashScreen;
    private GoogleARCoreApi m_ARCoreApi;
    private B m_FakeListener;
    private Camera2Wrapper m_Camera2Wrapper;
    private HFPStatus m_HFPStatus;
    private AudioVolumeHandler m_AudioVolumeHandler;
    private OrientationLockListener m_OrientationLockListener;
    private Uri m_launchUri;
    private NetworkConnectivity m_NetworkConnectivity;
    private IUnityPlayerLifecycleEvents m_UnityPlayerLifecycleEvents;
    private int m_IsNoWindowMode;
    Window m_Window;
    private Context mContext;
    private Activity mActivity;
    private I mGlView;
    private boolean mQuitting;
    private boolean mProcessKillRequested;
    private U mVideoPlayerProxy;
    com.unity3d.player.B mSoftInputDialog;

    public UnityPlayer(Context context) {
        this(context, null);
    }

    public UnityPlayer(Context object, IUnityPlayerLifecycleEvents object2) {
        super(object);
        I i2;
        B b2;
        D d2;
        F f2;
        ConcurrentLinkedQueue concurrentLinkedQueue;
        J j2;
        Handler handler;
        Object object3 = handler;
        handler = new Handler();
        this.mHandler = object3;
        this.mInitialScreenOrientation = -1;
        this.mMainDisplayOverride = false;
        this.mIsFullscreen = true;
        object3 = j2;
        j2 = new J();
        this.mState = object3;
        object3 = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        this.m_Events = object3;
        this.mOrientationListener = null;
        object3 = f2;
        f2 = new F();
        this.m_MainThread = object3;
        this.m_AddPhoneCallListener = false;
        object3 = d2;
        d2 = new D();
        this.m_PhoneCallListener = object3;
        this.m_ARCoreApi = null;
        object3 = b2;
        b2 = new B(this);
        this.m_FakeListener = object3;
        this.m_Camera2Wrapper = null;
        this.m_HFPStatus = null;
        this.m_AudioVolumeHandler = null;
        this.m_OrientationLockListener = null;
        this.m_launchUri = null;
        this.m_NetworkConnectivity = null;
        this.m_UnityPlayerLifecycleEvents = null;
        this.m_IsNoWindowMode = -1;
        this.mProcessKillRequested = true;
        this.mSoftInputDialog = null;
        if (object2 == null) {
            object2 = this;
        }
        Context context = object;
        this.m_UnityPlayerLifecycleEvents = object2;
        com.unity3d.player.G.a(UnityPlayer.getUnityNativeLibraryPath(context));
        currentContext = context;
        if (context instanceof Activity) {
            currentActivity = this.mActivity = (Activity)object;
            this.mInitialScreenOrientation = this.mActivity.getRequestedOrientation();
            this.m_launchUri = this.mActivity.getIntent().getData();
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.mContext = object;
        unityPlayer.EarlyEnableFullScreenIfEnabled();
        object2 = unityPlayer.getResources().getConfiguration();
        unityPlayer.prevConfig = object2;
        unityPlayer.mNaturalOrientation = unityPlayer.getNaturalOrientation(((Configuration)object2).orientation);
        if (unityPlayer.mActivity != null && this.getSplashEnabled()) {
            com.unity3d.player.C c2;
            object2 = c2;
            this.m_SplashScreen = new com.unity3d.player.C(this.mContext, C.a.a()[this.getSplashMode()]);
            this.addView((View)object2);
        }
        UnityPlayer.preloadJavaPlugins();
        object2 = UnityPlayer.loadNative(UnityPlayer.getUnityNativeLibraryPath(this.mContext));
        if (!J.d()) {
            DialogInterface.OnClickListener onClickListener;
            u.Log(6, "Your hardware does not support this application.");
            object = onClickListener;
            onClickListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    UnityPlayer.this.finish();
                }
            };
            AlertDialog alertDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Failure to initialize!").setPositiveButton((CharSequence)"OK", (DialogInterface.OnClickListener)object).setMessage((CharSequence)("Your hardware does not support this application." + "\n\n" + (String)object2 + "\n\n Press OK to quit.")).create();
            alertDialog.setCancelable(false);
            alertDialog.show();
            return;
        }
        UnityPlayer unityPlayer2 = this;
        unityPlayer2.initJni((Context)object);
        unityPlayer2.mState.d(true);
        object2 = i2;
        unityPlayer2.mGlView = new I((Context)object, this);
        unityPlayer2.addView((View)object2);
        unityPlayer2.bringChildToFront(unityPlayer2.m_SplashScreen);
        unityPlayer2.mQuitting = false;
        object = unityPlayer2.mActivity;
        if (object != null) {
            this.m_Window = object.getWindow();
        }
        UnityPlayer unityPlayer3 = this;
        unityPlayer3.hideStatusBar();
        unityPlayer3.m_TelephonyManager = (TelephonyManager)unityPlayer3.mContext.getSystemService("phone");
        unityPlayer3.m_ClipboardManager = (ClipboardManager)unityPlayer3.mContext.getSystemService("clipboard");
        unityPlayer3.m_Camera2Wrapper = new Camera2Wrapper(this.mContext);
        unityPlayer3.m_HFPStatus = new HFPStatus(this.mContext);
        unityPlayer3.m_MainThread.start();
    }

    private int getNaturalOrientation(int n2) {
        int n3 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if ((n3 != 0 && n3 != 2 || n2 != 2) && (n3 != 1 && n3 != 3 || n2 != 1)) {
            return 1;
        }
        return 0;
    }

    private String GetGlViewContentDescription(Context context) {
        String string = context.getPackageName();
        return context.getResources().getString(context.getResources().getIdentifier("game_view_content_description", "string", string));
    }

    private void DisableStaticSplashScreen() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                UnityPlayer unityPlayer = UnityPlayer.this;
                unityPlayer.removeView(unityPlayer.m_SplashScreen);
                UnityPlayer.this.m_SplashScreen = null;
            }
        };
        this.runOnUiThread(runnable2);
    }

    private void EarlyEnableFullScreenIfEnabled() {
        Activity activity = this.mActivity;
        if (activity != null && activity.getWindow() != null && (this.getLaunchFullscreen() || this.mActivity.getIntent().getBooleanExtra("android.intent.extra.VR_LAUNCH", false)) && (this = this.mActivity.getWindow().getDecorView()) != null) {
            this.setSystemUiVisibility(7);
        }
    }

    private boolean IsWindowTranslucent() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer == null) {
            return false;
        }
        unityPlayer = unityPlayer.getTheme().obtainStyledAttributes(new int[]{16842840});
        boolean bl = unityPlayer.getBoolean(0, false);
        unityPlayer.recycle();
        return bl;
    }

    private boolean updateDisplayInternal(final int n2, final Surface surface) {
        if (J.d() && ((UnityPlayer)object).mState.a()) {
            block14: {
                Object object;
                v v2;
                Semaphore semaphore;
                final Semaphore semaphore2 = semaphore;
                semaphore = new Semaphore(0);
                var v3 = v2;
                v2 = new Runnable(){

                    @Override
                    public void run() {
                        v v2 = this;
                        v v3 = this;
                        int n22 = v3.n2;
                        v2.UnityPlayer.this.nativeRecreateGfxState(n22, v3.surface);
                        v2.semaphore2.release();
                    }
                };
                if (n2 == 0) {
                    if (surface == null) {
                        object = ((UnityPlayer)object).m_MainThread;
                        Handler handler = ((F)object).a;
                        if (handler != null) {
                            Message.obtain((Handler)handler, (int)2269, (Object)((Object)E.d)).sendToTarget();
                            Message.obtain((Handler)((F)object).a, (Runnable)v3).sendToTarget();
                        }
                    } else {
                        object = ((UnityPlayer)object).m_MainThread;
                        Handler handler = ((F)object).a;
                        if (handler != null) {
                            Object object2 = object;
                            Message.obtain((Handler)handler, (Runnable)v3).sendToTarget();
                            object = E.e;
                            v3 = ((F)object2).a;
                            if (v3 != null) {
                                Message.obtain((Handler)v3, (int)2269, (Object)object).sendToTarget();
                            }
                        }
                    }
                } else {
                    v3.run();
                }
                if (surface == null && n2 == 0) {
                    Semaphore semaphore3 = semaphore2;
                    object = SynchronizationTimeout.SurfaceDetach;
                    long l2 = ((SynchronizationTimeout)((Object)object)).getTimeout();
                    if (semaphore3.tryAcquire(l2, TimeUnit.MILLISECONDS)) break block14;
                    try {
                        u.Log(5, "Timeout (" + ((SynchronizationTimeout)((Object)object)).getTimeout() + " ms) while trying detaching primary window.");
                    }
                    catch (InterruptedException interruptedException) {
                        u.Log(5, "UI thread got interrupted while trying to detach the primary window from the Unity Engine.");
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void UnitySendMessage(String string, String string2, String string3) {
        if (!J.d()) {
            u.Log(5, "Native libraries not loaded - dropping message for " + string + "." + string2);
            return;
        }
        try {
            UnityPlayer.nativeUnitySendMessage(string, string2, string3.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static native void nativeUnitySendMessage(String var0, String var1, byte[] var2);

    private void finish() {
        Activity activity = this.mActivity;
        if (activity != null && !activity.isFinishing()) {
            this.mActivity.finish();
        }
    }

    private void queueDestroy() {
        Runnable runnable;
        u.Log(4, "Queue Destroy");
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                UnityPlayer.this.destroy();
            }
        };
        this.runOnUiThread(runnable2);
    }

    private void pauseUnity() {
        UnityPlayer unityPlayer = this;
        unityPlayer.reportSoftInputStr(null, 1, true);
        if (unityPlayer.mState.c() && !this.mState.b()) {
            block11: {
                if (J.d()) {
                    Runnable runnable;
                    Semaphore semaphore;
                    Object object = semaphore;
                    semaphore = new Semaphore(0);
                    if (this.isFinishing()) {
                        Runnable runnable2;
                        runnable = runnable2;
                        runnable2 = new Runnable((Semaphore)object){
                            final /* synthetic */ Semaphore a;
                            {
                                this.a = semaphore;
                            }

                            @Override
                            public void run() {
                                y y2 = this;
                                y2.UnityPlayer.this.shutdown();
                                y2.a.release();
                            }
                        };
                    } else {
                        Runnable runnable3;
                        runnable = runnable3;
                        runnable3 = new Runnable((Semaphore)object){
                            final /* synthetic */ Semaphore a;
                            {
                                this.a = semaphore;
                            }

                            @Override
                            public void run() {
                                if (UnityPlayer.this.nativePause()) {
                                    z z2 = this;
                                    z2.UnityPlayer.this.mQuitting = true;
                                    z2.UnityPlayer.this.shutdown();
                                    z2.UnityPlayer.this.queueDestroy();
                                }
                                this.a.release();
                            }
                        };
                    }
                    F f2 = this.m_MainThread;
                    Handler handler = f2.a;
                    if (handler != null) {
                        Message.obtain((Handler)handler, (int)2269, (Object)((Object)E.a)).sendToTarget();
                        Message.obtain((Handler)f2.a, (Runnable)runnable).sendToTarget();
                    }
                    Semaphore semaphore2 = object;
                    object = SynchronizationTimeout.Pause;
                    long l2 = ((SynchronizationTimeout)((Object)object)).getTimeout();
                    if (semaphore2.tryAcquire(l2, TimeUnit.MILLISECONDS)) break block11;
                    try {
                        u.Log(5, "Timeout (" + ((SynchronizationTimeout)((Object)object)).getTimeout() + " ms) while trying to pause the Unity Engine.");
                    }
                    catch (InterruptedException interruptedException) {
                        u.Log(5, "UI thread got interrupted while trying to pause the Unity Engine.");
                    }
                }
            }
            UnityPlayer unityPlayer2 = this;
            unityPlayer2.mState.c(false);
            unityPlayer2.mState.e(true);
            if (unityPlayer2.m_AddPhoneCallListener) {
                this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 0);
            }
            return;
        }
    }

    private void shutdown() {
        UnityPlayer unityPlayer = this;
        unityPlayer.mProcessKillRequested = unityPlayer.nativeDone();
        unityPlayer.mState.d(false);
    }

    private void checkResumePlayer() {
        boolean bl = false;
        Activity activity = object.mActivity;
        if (activity != null) {
            bl = MultiWindowSupport.isInMultiWindowMode(activity);
        }
        if (!object.mState.a(bl)) {
            return;
        }
        UnityPlayer unityPlayer = object;
        unityPlayer.mState.c(true);
        unityPlayer.queueGLThreadEvent(new Runnable(){

            @Override
            public void run() {
                UnityPlayer.this.nativeResume();
            }
        });
        Object object = E.b;
        Handler handler = unityPlayer.m_MainThread.a;
        if (handler != null) {
            Message.obtain((Handler)handler, (int)2269, (Object)object).sendToTarget();
        }
    }

    private final native void initJni(Context var1);

    private final native boolean nativeRender();

    private final native void nativeSetInputArea(int var1, int var2, int var3, int var4);

    private final native void nativeSetKeyboardIsVisible(boolean var1);

    private final native void nativeSetInputString(String var1);

    private final native void nativeSetInputSelection(int var1, int var2);

    private final native void nativeSoftInputCanceled();

    private final native void nativeSoftInputLostFocus();

    private final native void nativeReportKeyboardConfigChanged();

    private final native boolean nativePause();

    private final native void nativeResume();

    private final native void nativeLowMemory();

    private final native void nativeApplicationUnload();

    private final native void nativeFocusChanged(boolean var1);

    private final native void nativeRecreateGfxState(int var1, Surface var2);

    private final native void nativeSendSurfaceChangedEvent();

    private final native boolean nativeDone();

    private final native void nativeSoftInputClosed();

    private final native boolean nativeInjectEvent(InputEvent var1);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeMuteMasterAudio(boolean var1);

    private final native void nativeRestartActivityIndicator();

    private final native void nativeSetLaunchURL(String var1);

    private final native void nativeOrientationChanged(int var1, int var2);

    private final native boolean nativeGetNoWindowMode();

    private final native void nativeHidePreservedContent();

    private static String logLoadLibMainError(String string, String string2) {
        String string3 = "Failed to load 'libmain.so'\n\n" + string2;
        u.Log(6, string3);
        return string3;
    }

    private static void preloadJavaPlugins() {
        try {
            Class.forName("com.unity3d.JavaPluginPreloader");
        }
        catch (LinkageError linkageError) {
            u.Log(6, "Java class preloading failed: " + linkageError.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadNative(String var0) {
        var1_1 = var0 + "/libmain.so";
        try {
            System.load(var1_1);
            ** GOTO lbl12
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                System.loadLibrary("main");
            }
            catch (SecurityException v1) {
                return UnityPlayer.logLoadLibMainError(var1_1, v1.toString());
            }
lbl12:
            // 2 sources

            if (NativeLoader.load(var0)) {
                J.e();
                return "";
            }
            u.Log(6, "NativeLoader.load failure, Unity libraries were not loaded.");
            return "NativeLoader.load failure, Unity libraries were not loaded.";
            catch (UnsatisfiedLinkError v2) {
                return UnityPlayer.logLoadLibMainError(var1_1, v2.toString());
            }
        }
    }

    private static void unloadNative() {
        if (!J.d()) {
            return;
        }
        if (NativeLoader.unload()) {
            J.f();
            return;
        }
        throw new UnsatisfiedLinkError("Unable to unload libraries from libmain.so");
    }

    private static String getUnityNativeLibraryPath(Context context) {
        return context.getApplicationInfo().nativeLibraryDir;
    }

    private void hidePreservedContent() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                Object object = object.UnityPlayer.this.mGlView;
                if (object != null) {
                    ((I)((Object)object)).b();
                }
            }
        };
        this.runOnUiThread(runnable2);
    }

    private String getProcessName() {
        int n2 = Process.myPid();
        Object object = ((ActivityManager)this.mContext.getSystemService("activity")).getRunningAppProcesses();
        if (object == null) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
            if (runningAppProcessInfo.pid != n2) continue;
            return runningAppProcessInfo.processName;
        }
        return null;
    }

    private ApplicationInfo getApplicationInfo() {
        return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
    }

    private ActivityInfo getActivityInfo() {
        return this.mActivity.getPackageManager().getActivityInfo(this.mActivity.getComponentName(), 128);
    }

    private boolean getSplashEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getARCoreEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(ARCORE_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getLaunchFullscreen() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(LAUNCH_FULLSCREEN);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getHaveAndroidWindowSupport() {
        if (this.m_IsNoWindowMode == -1) {
            this.m_IsNoWindowMode = this.nativeGetNoWindowMode() ? 1 : 0;
        }
        return this.m_IsNoWindowMode == 1;
    }

    private boolean getAutoReportFullyDrawnEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void queueGLThreadEvent(G g2) {
        if (this.isFinishing()) {
            return;
        }
        this.queueGLThreadEvent((Runnable)g2);
    }

    private void hideStatusBar() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            unityPlayer.getWindow().setFlags(1024, 1024);
        }
    }

    private void swapViews(View view, View view2) {
        ViewParent viewParent;
        boolean bl = false;
        if (!this.mState.b()) {
            this.pause();
            bl = true;
        }
        if (!(view == null || (viewParent = view.getParent()) instanceof UnityPlayer && (UnityPlayer)viewParent == this)) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            UnityPlayer unityPlayer = this;
            unityPlayer.addView(view);
            unityPlayer.bringChildToFront(view);
            view.setVisibility(0);
        }
        if (view2 != null && view2.getParent() == this) {
            view2.setVisibility(8);
            this.removeView(view2);
        }
        if (bl) {
            this.resume();
        }
    }

    static {
        new com.unity3d.player.G().a();
    }

    @Override
    public void onUnityPlayerUnloaded() {
    }

    @Override
    public void onUnityPlayerQuitted() {
    }

    protected void toggleGyroscopeSensor(boolean bl) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(11);
        if (bl) {
            sensorManager.registerListener((SensorEventListener)this.m_FakeListener, sensor, 1);
        } else {
            sensorManager.unregisterListener((SensorEventListener)this.m_FakeListener);
        }
    }

    void sendSurfaceChangedEvent() {
        if (J.d() && unityPlayer.mState.a()) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    UnityPlayer.this.nativeSendSurfaceChangedEvent();
                }
            };
            UnityPlayer unityPlayer = unityPlayer.m_MainThread.a;
            if (unityPlayer != null) {
                Message.obtain((Handler)unityPlayer, (Runnable)runnable2).sendToTarget();
            }
            return;
        }
    }

    void updateGLDisplay(int n2, Surface surface) {
        if (this.mMainDisplayOverride) {
            return;
        }
        this.updateDisplayInternal(n2, surface);
    }

    public boolean displayChanged(int n2, Surface surface) {
        if (n2 == 0) {
            Runnable runnable;
            boolean bl = surface != null;
            this.mMainDisplayOverride = bl;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    UnityPlayer unityPlayer = UnityPlayer.this;
                    if (unityPlayer.mMainDisplayOverride) {
                        UnityPlayer unityPlayer2 = unityPlayer;
                        unityPlayer2.removeView((View)unityPlayer2.mGlView);
                    } else if (unityPlayer.mGlView.getParent() == null) {
                        UnityPlayer unityPlayer3 = UnityPlayer.this;
                        unityPlayer3.addView((View)unityPlayer3.mGlView);
                    } else {
                        u.Log(5, "Couldn't add view, because it's already assigned to another parent");
                    }
                }
            };
            this.runOnUiThread(runnable2);
        }
        return this.updateDisplayInternal(n2, surface);
    }

    void runOnAnonymousThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    void runOnUiThread(Runnable runnable) {
        Activity activity = this.mActivity;
        if (activity != null) {
            activity.runOnUiThread(runnable);
        } else if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public void init(int n2, boolean bl) {
    }

    public View getView() {
        return this;
    }

    public Bundle getSettings() {
        return Bundle.EMPTY;
    }

    public void quit() {
        this.destroy();
    }

    public void newIntent(Intent intent) {
        UnityPlayer unityPlayer;
        object.m_launchUri = intent.getData();
        Object object = E.i;
        intent = unityPlayer.m_MainThread.a;
        if (intent != null) {
            Message.obtain((Handler)intent, (int)2269, (Object)object).sendToTarget();
        }
    }

    public void destroy() {
        Object object = this.m_Camera2Wrapper;
        if (object != null) {
            ((Camera2Wrapper)object).a();
            this.m_Camera2Wrapper = null;
        }
        if ((object = this.m_HFPStatus) != null) {
            ((HFPStatus)object).a();
            this.m_HFPStatus = null;
        }
        if ((object = this.m_NetworkConnectivity) != null) {
            ((NetworkConnectivity)((Object)object)).a();
            this.m_NetworkConnectivity = null;
        }
        this.mQuitting = true;
        if (!this.mState.b()) {
            this.pause();
        }
        object = E.c;
        Handler handler = this.m_MainThread.a;
        if (handler != null) {
            Message.obtain((Handler)handler, (int)2269, (Object)object).sendToTarget();
        }
        F f2 = this.m_MainThread;
        long l2 = SynchronizationTimeout.Destroy.getTimeout();
        try {
            f2.join(l2);
        }
        catch (InterruptedException interruptedException) {
            this.m_MainThread.interrupt();
        }
        if (J.d()) {
            this.removeAllViews();
        }
        if (this.mProcessKillRequested) {
            UnityPlayer unityPlayer = this;
            unityPlayer.m_UnityPlayerLifecycleEvents.onUnityPlayerQuitted();
            unityPlayer.kill();
        }
        UnityPlayer.unloadNative();
    }

    protected void kill() {
        Process.killProcess((int)Process.myPid());
    }

    public void pause() {
        Object object = this.m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).pauseARCore();
        }
        if ((object = this.mVideoPlayerProxy) != null) {
            ((U)object).c();
        }
        if ((object = this.m_AudioVolumeHandler) != null) {
            ((AudioVolumeHandler)object).a();
            this.m_AudioVolumeHandler = null;
        }
        if ((object = this.m_OrientationLockListener) != null) {
            ((OrientationLockListener)object).a();
            this.m_OrientationLockListener = null;
        }
        this.pauseUnity();
    }

    public void resume() {
        Object object = this.m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).resumeARCore();
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.e(false);
        object = unityPlayer.mVideoPlayerProxy;
        if (object != null) {
            ((U)object).d();
        }
        this.checkResumePlayer();
        if (J.d()) {
            this.nativeRestartActivityIndicator();
        }
        if (this.m_AudioVolumeHandler == null) {
            this.m_AudioVolumeHandler = new AudioVolumeHandler(this.mContext);
        }
        if (this.m_OrientationLockListener == null && J.d()) {
            this.m_OrientationLockListener = new OrientationLockListener(this.mContext);
        }
        this.prevConfig = this.getResources().getConfiguration();
    }

    public void lowMemory() {
        Runnable runnable;
        if (!J.d()) {
            return;
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                UnityPlayer.this.nativeLowMemory();
            }
        };
        this.queueGLThreadEvent(runnable2);
    }

    public void unload() {
        this.nativeApplicationUnload();
    }

    protected boolean skipPermissionsDialog() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            return UnityPermissions.skipPermissionsDialog((Activity)unityPlayer);
        }
        return false;
    }

    protected void requestUserAuthorization(String string) {
        if (string != null && !string.isEmpty() && this.mActivity != null) {
            UnityPermissions.ModalWaitForPermissionResponse modalWaitForPermissionResponse;
            UnityPermissions.ModalWaitForPermissionResponse modalWaitForPermissionResponse2 = modalWaitForPermissionResponse;
            modalWaitForPermissionResponse2();
            UnityPermissions.requestUserPermissions(this.mActivity, new String[]{string}, modalWaitForPermissionResponse2);
            modalWaitForPermissionResponse.waitForResponse();
        }
    }

    protected int getNetworkConnectivity() {
        NetworkConnectivity networkConnectivity = this.m_NetworkConnectivity;
        if (networkConnectivity != null) {
            return networkConnectivity.b();
        }
        this.m_NetworkConnectivity = PlatformSupport.NOUGAT_SUPPORT ? new NetworkConnectivityNougat(this.mContext) : new NetworkConnectivity(this.mContext);
        return this.m_NetworkConnectivity.b();
    }

    public void configurationChanged(Configuration configuration) {
        Configuration configuration2;
        int n2 = ((UnityPlayer)object).prevConfig.diff(configuration);
        if ((n2 & 0x100) != 0 || (n2 & 0x400) != 0 || (n2 & 0x800) != 0 || (n2 & 0x80) != 0) {
            ((UnityPlayer)object).nativeHidePreservedContent();
        }
        UnityPlayer unityPlayer = object;
        Object object = configuration2;
        configuration2 = new Configuration(configuration);
        unityPlayer.prevConfig = object;
        object = unityPlayer.mVideoPlayerProxy;
        if (object != null) {
            ((U)object).b();
        }
    }

    public void windowFocusChanged(boolean bl) {
        com.unity3d.player.B b2;
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.b(bl);
        if (unityPlayer.mState.a() && ((b2 = this.mSoftInputDialog) == null || b2.d)) {
            if (bl) {
                E e2 = E.g;
                b2 = this.m_MainThread.a;
                if (b2 != null) {
                    Message.obtain((Handler)b2, (int)2269, (Object)((Object)e2)).sendToTarget();
                }
            } else {
                E e3 = E.f;
                b2 = this.m_MainThread.a;
                if (b2 != null) {
                    Message.obtain((Handler)b2, (int)2269, (Object)((Object)e3)).sendToTarget();
                }
            }
            this.checkResumePlayer();
            return;
        }
    }

    protected boolean loadLibrary(String string) {
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    protected void addPhoneCallListener() {
        this.m_AddPhoneCallListener = true;
        this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 32);
    }

    protected void showSoftInput(final String string, final int n2, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final String string2, final int n3, final boolean bl5, final boolean bl6) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        final UnityPlayer unityPlayer = this;
        runnable = new Runnable(){

            @Override
            public void run() {
                var b2 = this;
                var b3 = this;
                Context context = b3.UnityPlayer.this.mContext;
                UnityPlayer unityPlayer2 = b3.unityPlayer;
                String string3 = b3.string;
                int n22 = b3.n2;
                boolean bl7 = b3.bl;
                boolean bl22 = b3.bl2;
                boolean bl32 = b3.bl3;
                boolean bl42 = b3.bl4;
                String string22 = b3.string2;
                int n32 = b3.n3;
                boolean bl52 = b3.bl5;
                boolean bl62 = b3.bl6;
                b2.UnityPlayer.this.mSoftInputDialog = new com.unity3d.player.B(context, unityPlayer2, string3, n22, bl7, bl22, bl32, bl42, string22, n32, bl52, bl62);
                b2.UnityPlayer.this.mSoftInputDialog.setOnCancelListener(new DialogInterface.OnCancelListener(this){
                    final /* synthetic */ b a;
                    {
                        this.a = b2;
                    }

                    public void onCancel(DialogInterface dialogInterface) {
                        a a2 = this;
                        a2.a.UnityPlayer.this.nativeSoftInputLostFocus();
                        a2.a.UnityPlayer.this.reportSoftInputStr(null, 1, false);
                    }
                });
                b2.UnityPlayer.this.mSoftInputDialog.show();
                b2.UnityPlayer.this.nativeReportKeyboardConfigChanged();
            }
        };
        this.postOnUiThread(runnable2);
    }

    protected void hideSoftInput() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                d d2 = this;
                d2.UnityPlayer.this.reportSoftInputArea(new Rect());
                d2.UnityPlayer.this.reportSoftInputIsVisible(false);
                com.unity3d.player.B b2 = d2.UnityPlayer.this.mSoftInputDialog;
                if (b2 != null) {
                    b2.dismiss();
                    UnityPlayer.this.mSoftInputDialog = null;
                    UnityPlayer.this.nativeReportKeyboardConfigChanged();
                }
            }
        };
        this.postOnUiThread(runnable2);
    }

    protected void setSoftInputStr(final String string) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                com.unity3d.player.B b2 = UnityPlayer.this.mSoftInputDialog;
                if (b2 != null && (this = string) != null) {
                    b2.a((String)this);
                }
            }
        };
        this.runOnUiThread(runnable2);
    }

    protected void setCharacterLimit(final int n2) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                com.unity3d.player.B b2 = UnityPlayer.this.mSoftInputDialog;
                if (b2 != null) {
                    b2.a(n2);
                }
            }
        };
        this.runOnUiThread(runnable2);
    }

    protected void setHideInputField(final boolean bl) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                com.unity3d.player.B b2 = UnityPlayer.this.mSoftInputDialog;
                if (b2 != null) {
                    b2.a(bl);
                }
            }
        };
        this.runOnUiThread(runnable2);
    }

    protected void setSelection(final int n2, final int n3) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                com.unity3d.player.B b2 = UnityPlayer.this.mSoftInputDialog;
                if (b2 != null) {
                    h h2 = this;
                    int n22 = h2.n2;
                    b2.a(n22, h2.n3);
                }
            }
        };
        this.runOnUiThread(runnable2);
    }

    protected String getKeyboardLayout() {
        Object object = object.mSoftInputDialog;
        if (object == null) {
            return null;
        }
        return ((com.unity3d.player.B)((Object)object)).a();
    }

    protected void reportSoftInputStr(final String string, final int n2, final boolean bl) {
        G g2;
        if (n2 == 1) {
            this.hideSoftInput();
        }
        G g3 = g2;
        g2 = new G(){

            @Override
            public void a() {
                if (bl) {
                    UnityPlayer.this.nativeSoftInputCanceled();
                } else {
                    String string2 = string;
                    if (string2 != null) {
                        UnityPlayer.this.nativeSetInputString(string2);
                    }
                }
                if (n2 == 1) {
                    UnityPlayer.this.nativeSoftInputClosed();
                }
            }
        };
        this.queueGLThreadEvent(g3);
    }

    protected void reportSoftInputSelection(final int n2, final int n3) {
        G g2;
        G g3 = g2;
        g2 = new G(){

            @Override
            public void a() {
                j j2 = this;
                int n22 = j2.n2;
                UnityPlayer.this.nativeSetInputSelection(n22, j2.n3);
            }
        };
        this.queueGLThreadEvent(g3);
    }

    protected void reportSoftInputArea(final Rect rect) {
        G g2;
        G g3 = g2;
        g2 = new G(){

            @Override
            public void a() {
                Rect rect2 = rect;
                int n2 = rect2.left;
                int n3 = rect2.top;
                int n4 = rect2.right;
                int n5 = rect2.bottom;
                UnityPlayer.this.nativeSetInputArea(n2, n3, n4, n5);
            }
        };
        this.queueGLThreadEvent(g3);
    }

    protected void reportSoftInputIsVisible(final boolean bl) {
        G g2;
        G g3 = g2;
        g2 = new G(){

            @Override
            public void a() {
                UnityPlayer.this.nativeSetKeyboardIsVisible(bl);
            }
        };
        this.queueGLThreadEvent(g3);
    }

    protected void setClipboardText(String string) {
        UnityPlayer unityPlayer = unityPlayer2;
        UnityPlayer unityPlayer2 = ClipData.newPlainText((CharSequence)"Text", (CharSequence)string);
        unityPlayer.m_ClipboardManager.setPrimaryClip((ClipData)unityPlayer2);
    }

    protected String getClipboardText() {
        String string = "";
        ClipData clipData = this.m_ClipboardManager.getPrimaryClip();
        if (clipData != null) {
            string = clipData.getItemAt(0).coerceToText(this.mContext).toString();
        }
        return string;
    }

    protected String getLaunchURL() {
        UnityPlayer unityPlayer = unityPlayer.m_launchUri;
        return unityPlayer != null ? unityPlayer.toString() : null;
    }

    protected boolean initializeGoogleAr() {
        if (this.m_ARCoreApi == null && this.mActivity != null && this.getARCoreEnabled()) {
            GoogleARCoreApi googleARCoreApi;
            GoogleARCoreApi googleARCoreApi2;
            GoogleARCoreApi googleARCoreApi3 = googleARCoreApi2 = googleARCoreApi;
            googleARCoreApi3();
            this.m_ARCoreApi = googleARCoreApi3;
            googleARCoreApi.initializeARCore(this.mActivity);
            if (!this.mState.b()) {
                this.m_ARCoreApi.resumeARCore();
            }
        }
        return false;
    }

    protected boolean showVideoPlayer(String string, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        U.a a2;
        if (this.mVideoPlayerProxy == null) {
            U u2;
            U u3 = u2;
            u2 = new U(this);
            this.mVideoPlayerProxy = u3;
        }
        Object object = this.mContext;
        long l2 = n5;
        long l3 = n6;
        Context context = object;
        object = a2;
        a2 = new U.a(){

            public void a() {
                UnityPlayer.this.mVideoPlayerProxy = null;
            }
        };
        boolean bl2 = this.mVideoPlayerProxy.a(context, string, n2, n3, n4, bl, l2, l3, (U.a)object);
        if (bl2) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (unityPlayer.UnityPlayer.this.nativeIsAutorotationOn()) {
                        UnityPlayer unityPlayer = unityPlayer.UnityPlayer.this;
                        Activity activity = unityPlayer.mActivity;
                        if (activity != null) {
                            activity.setRequestedOrientation(unityPlayer.mInitialScreenOrientation);
                        }
                    }
                }
            };
            this.runOnUiThread(runnable2);
        }
        return bl2;
    }

    protected void pauseJavaAndCallUnloadCallback() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                p p2 = this;
                p2.UnityPlayer.this.pause();
                p2.UnityPlayer.this.windowFocusChanged(false);
                p2.UnityPlayer.this.m_UnityPlayerLifecycleEvents.onUnityPlayerUnloaded();
            }
        };
        this.runOnUiThread(runnable2);
    }

    protected boolean isUaaLUseCase() {
        Object object = this.mActivity;
        if (object != null) {
            return (object = object.getCallingPackage()) != null && ((String)object).equals(this.mContext.getPackageName());
        }
        return false;
    }

    protected int getUaaLLaunchProcessType() {
        String string = this.getProcessName();
        return string != null && !string.equals(this.mContext.getPackageName()) ? 1 : 0;
    }

    protected int getSplashMode() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_MODE_METADATA_NAME);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void executeGLThreadJobs() {
        Runnable runnable;
        while ((runnable = (Runnable)this.m_Events.poll()) != null) {
            runnable.run();
        }
    }

    protected void disableLogger() {
        u.a = true;
    }

    void queueGLThreadEvent(Runnable runnable) {
        if (!J.d()) {
            return;
        }
        if (Thread.currentThread() == this.m_MainThread) {
            runnable.run();
        } else {
            this.m_Events.add(runnable);
        }
    }

    protected boolean isFinishing() {
        if (this.mQuitting) {
            return true;
        }
        Activity activity = this.mActivity;
        if (activity != null) {
            this.mQuitting = activity.isFinishing();
        }
        return this.mQuitting;
    }

    public boolean injectEvent(InputEvent inputEvent) {
        if (!J.d()) {
            return false;
        }
        return this.nativeInjectEvent(inputEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyMultiple(int n2, int n3, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyLongPress(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.mGlView.c() ? this.injectEvent((InputEvent)motionEvent) : false;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return !this.mGlView.c() ? this.injectEvent((InputEvent)motionEvent) : false;
    }

    public boolean addViewToPlayer(View view, boolean bl) {
        I i2 = bl ? this.mGlView : null;
        this.swapViews(view, (View)i2);
        boolean bl2 = view.getParent() == this;
        bl = bl && this.mGlView.getParent() == null;
        boolean bl3 = this.mGlView.getParent() == this;
        boolean bl4 = bl2 && (bl || bl3);
        if (!bl4) {
            if (!bl2) {
                u.Log(6, "addViewToPlayer: Failure adding view to hierarchy");
            }
            if (!bl && !bl3) {
                u.Log(6, "addViewToPlayer: Failure removing old view from hierarchy");
            }
        }
        return bl4;
    }

    public void removeViewFromPlayer(View view) {
        UnityPlayer unityPlayer = this;
        unityPlayer.swapViews((View)unityPlayer.mGlView, view);
        boolean bl = view.getParent() == null;
        boolean bl2 = this.mGlView.getParent() == this;
        if (!(bl && bl2)) {
            if (!bl) {
                u.Log(6, "removeViewFromPlayer: Failure removing view from hierarchy");
            }
            if (!bl2) {
                u.Log(6, "removeVireFromPlayer: Failure agging old view to hierarchy");
            }
        }
    }

    public void reportError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        u.Log(6, stringBuilder.toString());
    }

    public String getNetworkProxySettings(String string) {
        block8: {
            String string2;
            Object object;
            block7: {
                block6: {
                    if (!string.startsWith("http:")) break block6;
                    object = "http.proxyHost";
                    string = "http.proxyPort";
                    string2 = "http.nonProxyHosts";
                    break block7;
                }
                if (!string.startsWith("https:")) break block8;
                object = "https.proxyHost";
                string = "https.proxyPort";
                string2 = "http.nonProxyHosts";
            }
            object = System.getProperties().getProperty((String)object);
            if (object != null && !"".equals(object)) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder = new StringBuilder((String)object);
                object = System.getProperties().getProperty(string);
                if (object != null && !"".equals(object)) {
                    stringBuilder2.append(":").append((String)object);
                }
                if ((object = System.getProperties().getProperty(string2)) != null && !"".equals(object)) {
                    stringBuilder2.append('\n').append((String)object);
                }
                return stringBuilder2.toString();
            }
            return null;
        }
        return null;
    }

    public boolean startOrientationListener(int n2) {
        OrientationEventListener orientationEventListener;
        if (this.mOrientationListener != null) {
            u.Log(5, "Orientation Listener already started.");
            return false;
        }
        OrientationEventListener orientationEventListener2 = orientationEventListener;
        UnityPlayer unityPlayer = this;
        this.mOrientationListener = new OrientationEventListener(unityPlayer.mContext, n2){

            public void onOrientationChanged(int n2) {
                Object object = object.UnityPlayer.this;
                ((UnityPlayer)object).m_MainThread.f = ((UnityPlayer)object).mNaturalOrientation;
                ((UnityPlayer)object).m_MainThread.g = n2;
                object = E.j;
                Handler handler = ((UnityPlayer)object).m_MainThread.a;
                if (handler != null) {
                    Message.obtain((Handler)handler, (int)2269, (Object)object).sendToTarget();
                }
            }
        };
        if (orientationEventListener2.canDetectOrientation()) {
            this.mOrientationListener.enable();
            return true;
        }
        u.Log(5, "Orientation Listener cannot detect orientation.");
        return false;
    }

    public boolean stopOrientationListener() {
        OrientationEventListener orientationEventListener = this.mOrientationListener;
        if (orientationEventListener == null) {
            u.Log(5, "Orientation Listener was not started.");
            return false;
        }
        orientationEventListener.disable();
        this.mOrientationListener = null;
        return true;
    }

    public void setMainSurfaceViewAspectRatio(final float f2) {
        if (this.mGlView != null) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    UnityPlayer.this.mGlView.a(f2);
                }
            };
            this.runOnUiThread(runnable2);
        }
    }

    public void setScreenBrightness(final float f2) {
        f2 = Math.max(0.04f, f2);
        if (this.m_Window != null && this.getScreenBrightness() != f2) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    s s2 = this;
                    WindowManager.LayoutParams layoutParams = s2.UnityPlayer.this.m_Window.getAttributes();
                    s2.UnityPlayer.this.m_Window.getAttributes().screenBrightness = f2;
                    s2.UnityPlayer.this.m_Window.setAttributes(layoutParams);
                }
            };
            this.runOnUiThread(runnable2);
            return;
        }
    }

    public float getScreenBrightness() {
        float f2;
        Window window = this.m_Window;
        if (window == null) {
            return 1.0f;
        }
        float f3 = window.getAttributes().screenBrightness;
        if (f2 < 0.0f) {
            int n2 = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness", (int)255);
            if (PlatformSupport.PIE_SUPPORT) {
                double d2 = (Math.log(n2) * 19.811 - 9.411) / 100.0;
                d2 = Math.min(1.0, d2);
                return (float)Math.max(0.0, d2);
            }
            return (float)n2 / 255.0f;
        }
        return f3;
    }

    private abstract class G
    implements Runnable {
        private G() {
        }

        @Override
        public final void run() {
            if (!UnityPlayer.this.isFinishing()) {
                this.a();
            }
        }

        public abstract void a();
    }

    class B
    implements SensorEventListener {
        B(UnityPlayer unityPlayer) {
        }

        public void onAccuracyChanged(Sensor sensor, int n2) {
        }

        public void onSensorChanged(SensorEvent sensorEvent) {
        }
    }

    private class D
    extends PhoneStateListener {
        private D() {
        }

        public void onCallStateChanged(int n2, String string) {
            UnityPlayer unityPlayer = ((D)((Object)unityPlayer)).UnityPlayer.this;
            n2 = n2 == 1 ? 1 : 0;
            unityPlayer.nativeMuteMasterAudio(n2 != 0);
        }
    }

    private class F
    extends Thread {
        Handler a;
        boolean b = false;
        boolean c = false;
        C d = C.b;
        int e = 0;
        int f;
        int g;
        int h = 5;

        private F() {
        }

        @Override
        public void run() {
            Handler.Callback callback;
            Handler handler;
            this.setName("UnityMain");
            Looper.prepare();
            Handler handler2 = handler;
            Looper looper = Looper.myLooper();
            Handler.Callback callback2 = callback;
            callback = new Handler.Callback(this){
                final /* synthetic */ F a;
                {
                    this.a = f2;
                }

                private void a() {
                    F f2 = this.a;
                    if (f2.d == C.c && f2.c) {
                        f2.UnityPlayer.this.nativeFocusChanged(true);
                        this.a.d = C.a;
                    }
                }

                public boolean handleMessage(Message object) {
                    if (object.what != 2269) {
                        return false;
                    }
                    object = (E)((Object)object.obj);
                    E e2 = E.h;
                    if (object == e2) {
                        a a2 = this;
                        F f2 = a2.a;
                        --f2.e;
                        f2.UnityPlayer.this.executeGLThreadJobs();
                        object = a2.a;
                        if (!object.b) {
                            return true;
                        }
                        if (object.UnityPlayer.this.getHaveAndroidWindowSupport() && !this.a.c) {
                            return true;
                        }
                        object = this.a;
                        int n2 = object.h;
                        if (n2 >= 0) {
                            if (n2 == 0) {
                                if (object.UnityPlayer.this.getSplashEnabled()) {
                                    this.a.UnityPlayer.this.DisableStaticSplashScreen();
                                }
                                object = this.a.UnityPlayer.this;
                                if (object.mActivity != null && object.getAutoReportFullyDrawnEnabled()) {
                                    this.a.UnityPlayer.this.mActivity.reportFullyDrawn();
                                }
                            }
                            --this.a.h;
                        }
                        if (!this.a.UnityPlayer.this.isFinishing() && !this.a.UnityPlayer.this.nativeRender()) {
                            this.a.UnityPlayer.this.finish();
                        }
                    } else if (object == E.c) {
                        Looper.myLooper().quit();
                    } else if (object == E.b) {
                        this.a.b = true;
                    } else if (object == E.a) {
                        this.a.b = false;
                    } else if (object == E.d) {
                        this.a.c = false;
                    } else if (object == E.e) {
                        this.a.c = true;
                        this.a();
                    } else if (object == E.f) {
                        object = this.a;
                        if (object.d == C.a) {
                            object.UnityPlayer.this.nativeFocusChanged(false);
                        }
                        this.a.d = C.b;
                    } else if (object == E.g) {
                        this.a.d = C.c;
                        this.a();
                    } else if (object == E.i) {
                        UnityPlayer unityPlayer = this.a.UnityPlayer.this;
                        unityPlayer.nativeSetLaunchURL(unityPlayer.getLaunchURL());
                    } else if (object == E.j) {
                        object = this.a;
                        Object object2 = object;
                        int n3 = object2.f;
                        object.UnityPlayer.this.nativeOrientationChanged(n3, object2.g);
                    }
                    F f3 = this.a;
                    if (f3.b && f3.e <= 0) {
                        Message.obtain((Handler)f3.a, (int)2269, (Object)((Object)e2)).sendToTarget();
                        ++this.a.e;
                    }
                    return true;
                }
            };
            handler = new Handler(looper, callback2);
            this.a = handler2;
            Looper.loop();
        }
    }

    static final class C
    extends Enum {
        public static final /* enum */ C a = new C("GAINED", 0);
        public static final /* enum */ C b = new C("LOST", 1);
        public static final /* enum */ C c = new C("DEFERRED", 2);

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private C() {
            void var2_-1;
            void var1_-1;
        }
    }

    static final class E
    extends Enum {
        public static final /* enum */ E a = new E("PAUSE", 0);
        public static final /* enum */ E b = new E("RESUME", 1);
        public static final /* enum */ E c = new E("QUIT", 2);
        public static final /* enum */ E d = new E("SURFACE_LOST", 3);
        public static final /* enum */ E e = new E("SURFACE_ACQUIRED", 4);
        public static final /* enum */ E f = new E("FOCUS_LOST", 5);
        public static final /* enum */ E g = new E("FOCUS_GAINED", 6);
        public static final /* enum */ E h = new E("NEXT_FRAME", 7);
        public static final /* enum */ E i = new E("URL_ACTIVATED", 8);
        public static final /* enum */ E j = new E("ORIENTATION_ANGLE_CHANGE", 9);

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private E() {
            void var2_-1;
            void var1_-1;
        }
    }

    public static final class SynchronizationTimeout
    extends Enum {
        public static final /* enum */ SynchronizationTimeout Pause;
        public static final /* enum */ SynchronizationTimeout SurfaceDetach;
        public static final /* enum */ SynchronizationTimeout Destroy;
        private static final /* synthetic */ SynchronizationTimeout[] $VALUES;
        final int value;
        private int m_TimeoutMilliseconds;

        public static SynchronizationTimeout[] values() {
            return (SynchronizationTimeout[])$VALUES.clone();
        }

        public static SynchronizationTimeout valueOf(String string) {
            return Enum.valueOf(SynchronizationTimeout.class, string);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private SynchronizationTimeout() {
            void var3_2;
            void var2_-1;
            void var1_-1;
            this.value = var3_2;
            this.m_TimeoutMilliseconds = 2000;
        }

        public static void setTimeoutForAll(int n2) {
            SynchronizationTimeout[] synchronizationTimeoutArray = (SynchronizationTimeout[])SynchronizationTimeout.class.getEnumConstants();
            int n3 = synchronizationTimeoutArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                synchronizationTimeoutArray[i2].setTimeout(n2);
            }
        }

        static {
            SynchronizationTimeout synchronizationTimeout;
            SynchronizationTimeout synchronizationTimeout2;
            SynchronizationTimeout synchronizationTimeout3;
            SynchronizationTimeout synchronizationTimeout4 = synchronizationTimeout3;
            Pause = new SynchronizationTimeout("Pause", 0, 0);
            SynchronizationTimeout synchronizationTimeout5 = synchronizationTimeout2;
            SurfaceDetach = new SynchronizationTimeout("SurfaceDetach", 1, 1);
            SynchronizationTimeout synchronizationTimeout6 = synchronizationTimeout;
            Destroy = new SynchronizationTimeout("Destroy", 2, 2);
            $VALUES = new SynchronizationTimeout[]{synchronizationTimeout4, synchronizationTimeout5, synchronizationTimeout6};
        }

        public void setTimeout(int n2) {
            this.m_TimeoutMilliseconds = n2;
        }

        public int getTimeout() {
            return this.m_TimeoutMilliseconds;
        }
    }
}

