/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.unity3d.player.IPermissionRequestCallbacks;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.a.d;

public class UnityPermissions {
    private static final String SKIP_DIALOG_METADATA_NAME = "unityplayer.SkipPermissionsDialog";

    private static boolean checkInfoForMetadata(PackageItemInfo packageItemInfo) {
        try {
            return packageItemInfo.metaData.getBoolean(SKIP_DIALOG_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean skipPermissionsDialog(Activity activity) {
        block9: {
            block8: {
                PackageManager packageManager;
                if (!PlatformSupport.MARSHMALLOW_SUPPORT) {
                    return false;
                }
                try {
                    packageManager = activity.getPackageManager();
                }
                catch (Exception exception) {}
                Activity activity2 = activity;
                activity = packageManager.getActivityInfo(activity.getComponentName(), 128);
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(activity2.getPackageName(), 128);
                if (UnityPermissions.checkInfoForMetadata((PackageItemInfo)activity)) break block8;
                if (!UnityPermissions.checkInfoForMetadata((PackageItemInfo)applicationInfo)) break block9;
            }
            return true;
        }
        return false;
    }

    public static boolean hasUserAuthorizedPermission(Context context, String string) {
        return context.checkCallingOrSelfPermission(string) == 0;
    }

    public static void requestUserPermissions(Activity activity, String[] stringArray, IPermissionRequestCallbacks iPermissionRequestCallbacks) {
        if (!PlatformSupport.MARSHMALLOW_SUPPORT) {
            return;
        }
        if (activity != null && stringArray != null) {
            String string;
            Object object = activity.getFragmentManager();
            if (object.findFragmentByTag(string = String.valueOf(96489)) == null) {
                Bundle bundle;
                d d2;
                FragmentManager fragmentManager = object;
                object = d2;
                d2 = new d(activity, iPermissionRequestCallbacks);
                activity = bundle;
                new Bundle().putStringArray("PermissionNames", stringArray);
                d2.setArguments((Bundle)activity);
                FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
                fragmentTransaction.add(0, (Fragment)object, string);
                fragmentTransaction.commit();
            }
            return;
        }
    }

    public static class ModalWaitForPermissionResponse
    implements IPermissionRequestCallbacks {
        private boolean haveResponse = false;

        @Override
        public synchronized void onPermissionGranted(String string) {
            this.haveResponse = true;
            this.notify();
        }

        @Override
        public synchronized void onPermissionDenied(String string) {
            this.haveResponse = true;
            this.notify();
        }

        @Override
        public synchronized void onPermissionDeniedAndDontAskAgain(String string) {
            this.haveResponse = true;
            this.notify();
        }

        public synchronized void waitForResponse() {
            block3: {
                try {
                    if (!this.haveResponse) break block3;
                    return;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.wait();
        }
    }
}

