/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidgamesdk;

import android.app.Activity;
import android.content.ComponentName;
import android.hardware.display.DisplayManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SwappyDisplayManager
implements DisplayManager.DisplayListener {
    private final String LOG_TAG;
    private final boolean DEBUG;
    private final long ONE_MS_IN_NS;
    private final long ONE_S_IN_NS;
    private long mCookie;
    private Activity mActivity;
    private WindowManager mWindowManager;
    private Display.Mode mCurrentMode;
    private b mLooper;

    private boolean modeMatchesCurrentResolution(Display.Mode mode) {
        return mode.getPhysicalHeight() == this.mCurrentMode.getPhysicalHeight() && mode.getPhysicalWidth() == this.mCurrentMode.getPhysicalWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwappyDisplayManager(long l2, Activity activity) {
        block8: {
            this.LOG_TAG = "SwappyDisplayManager";
            this.DEBUG = false;
            this.ONE_MS_IN_NS = 1000000L;
            this.ONE_S_IN_NS = 1000000000L;
            Object object = activity.getPackageManager().getActivityInfo((ComponentName)activity.getIntent().getComponent(), (int)128).metaData;
            if (object == null) break block8;
            object = object.getString("android.app.lib_name");
            if (object == null) break block8;
            try {
                System.loadLibrary((String)object);
            }
            catch (Throwable throwable) {
                Log.e((String)"SwappyDisplayManager", (String)throwable.getMessage());
            }
        }
        SwappyDisplayManager swappyDisplayManager = this;
        this.mCookie = l2;
        this.mActivity = activity;
        this.mWindowManager = (WindowManager)activity.getSystemService(WindowManager.class);
        Display display = this.mWindowManager.getDefaultDisplay();
        swappyDisplayManager.mCurrentMode = display.getMode();
        swappyDisplayManager.updateSupportedRefreshRates(display);
        DisplayManager displayManager = (DisplayManager)swappyDisplayManager.mActivity.getSystemService(DisplayManager.class);
        SwappyDisplayManager swappyDisplayManager2 = this;
        synchronized (swappyDisplayManager2) {
            this.mLooper = new b(this);
            this.mLooper.start();
            displayManager.registerDisplayListener((DisplayManager.DisplayListener)swappyDisplayManager2, swappyDisplayManager2.mLooper.a);
            // ** MonitorExit[v1] (shouldn't be in output)
            return;
        }
    }

    private void updateSupportedRefreshRates(Display modeArray) {
        modeArray = modeArray.getSupportedModes();
        int n2 = 0;
        for (int i2 = 0; i2 < modeArray.length; ++i2) {
            if (!this.modeMatchesCurrentResolution(modeArray[i2])) continue;
            ++n2;
        }
        int n3 = n2;
        long[] lArray = new long[n3];
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < modeArray.length; ++i3) {
            if (!this.modeMatchesCurrentResolution(modeArray[i3])) continue;
            lArray[n4] = (long)(1.0E9f / modeArray[i3].getRefreshRate());
            nArray[n4] = modeArray[i3].getModeId();
            ++n4;
        }
        SwappyDisplayManager swappyDisplayManager = this;
        swappyDisplayManager.nSetSupportedRefreshPeriods(swappyDisplayManager.mCookie, lArray, nArray);
    }

    private native void nSetSupportedRefreshPeriods(long var1, long[] var3, int[] var4);

    private native void nOnRefreshPeriodChanged(long var1, long var3, long var5, long var7);

    public void setPreferredDisplayModeId(final int n2) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Window window = SwappyDisplayManager.this.mActivity.getWindow();
                window.getAttributes().preferredDisplayModeId = n2;
                window.setAttributes(window.getAttributes());
            }
        });
    }

    public void terminate() {
        this.mLooper.a.getLooper().quit();
    }

    public void onDisplayAdded(int n2) {
    }

    public void onDisplayRemoved(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onDisplayChanged(int var1_1) {
        v0 = this;
        synchronized (v0) {
            block13: {
                var1_2 = v0.mWindowManager.getDefaultDisplay();
                var2_3 = var1_2.getRefreshRate();
                var3_4 = var1_2.getMode();
                var4_6 = var3_4.getPhysicalWidth() != this.mCurrentMode.getPhysicalWidth();
                var5_7 = var3_4.getPhysicalHeight() != this.mCurrentMode.getPhysicalHeight();
                var4_6 |= var5_7;
                var5_7 = var2_3 != this.mCurrentMode.getRefreshRate();
                this.mCurrentMode = var3_4;
                if (!var4_6) break block13;
                this.updateSupportedRefreshRates(var1_2);
            }
            if (!var5_7) ** GOTO lbl38
            v2 = this;
            v3 = v2;
            v4 = v2;
            v5 = v2;
            var3_5 = var1_2.getAppVsyncOffsetNanos();
            var5_8 = v4.mWindowManager.getDefaultDisplay().getPresentationDeadlineNanos();
            var7_9 = (long)(1.0E9f / var2_3);
            var5_8 = var7_9 - (var5_8 - 1000000L);
            v3.nOnRefreshPeriodChanged(v5.mCookie, var7_9, var3_5, var5_8);
lbl38:
            // 2 sources

            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    private class b
    extends Thread {
        public Handler a;
        private Lock b;
        private Condition c;

        private b(SwappyDisplayManager swappyDisplayManager) {
            ReentrantLock reentrantLock;
            ReentrantLock reentrantLock2 = reentrantLock;
            v1.b = new ReentrantLock();
            v1.c = reentrantLock2.newCondition();
        }

        @Override
        public void start() {
            b b2 = this;
            b2.b.lock();
            super.start();
            try {
                b2.c.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.b.unlock();
        }

        @Override
        public void run() {
            b b2 = this;
            Log.i((String)"SwappyDisplayManager", (String)"Starting looper thread");
            b2.b.lock();
            Looper.prepare();
            b2.a = new Handler();
            b2.c.signal();
            b2.b.unlock();
            Looper.loop();
            Log.i((String)"SwappyDisplayManager", (String)"Terminating looper thread");
        }
    }
}

