using System.Collections;
using System.Collections.Generic;
using System.Linq.Expressions;
using UnityEngine;
using System;
using System.Linq;
using UnityEngine.SceneManagement;

//logica de rodadas
public class Encaixes : MonoBehaviour
{
    //pai de objetos interagiveis
    [SerializeField] GameObject objetosInteragiveis;

    //posiçoes de spawn
    private List<Vector3> posicoes = new List<Vector3>();

    //prefabs
    [SerializeField] GameObject encaixeTriangulo;
    [SerializeField] GameObject encaixeQuadrado;
    [SerializeField] GameObject encaixeEstrela;

    [SerializeField] GameObject quadrado;
    [SerializeField] GameObject estrela;
    [SerializeField] GameObject triangulo;

    [SerializeField] GameObject porta; 

    //teste
    private List<string> solidosEmJogo;
    private int testeQuant = 3;

    //atributos importantes
    private List<GameObject> solidos;
    private bool flag = true;
    private Encaixe_obj scriptDoObjetoDaRodadaAtual;
    System.Random randon = new System.Random();
    private int rodada = 0;
    private float tempo=0;
    private bool dicaLigadoDesligado = false;

    void Start()
    {

        posicoes.Add(new Vector3(-64.18264f, 9.7106f, -32.04821f));
        posicoes.Add(new Vector3(-45.55911f, 11.3f, -45.04777f));
        posicoes.Add(new Vector3(-84.14204f, 8.6f, -40.45529f));

        solidos = new List<GameObject> {quadrado, estrela, triangulo};

        solidosEmJogo = DadosEstaticosSolidos.solidosEmJogo;
        testeQuant = DadosEstaticosSolidos.quantidadeEncaixes;

        for(int i = 0; i < solidosEmJogo.Count; i++)
            Debug.Log("Solidos em jogo: " + solidosEmJogo[i]);
        Debug.Log("quantidade: " + testeQuant);


    }

    void Update()
    {

        jogar();

        if (DadosEstaticosSolidos.dica)
            ativarDica();
        
    }

    private void jogar()
    {
        if (flag)
        {
            if (rodada < testeQuant)
            {
                int i = randon.Next(solidosEmJogo.Count);
                string proxCombinacao = solidosEmJogo[i];

                instanciarEncaixes(proxCombinacao);

                if (rodada < solidosEmJogo.Count - 1)
                    solidosEmJogo.Remove(proxCombinacao);
                flag = false;
                rodada++;
            }
            else
            {
                //abre passagem para recompensa
                Destroy(porta);
            }
        }

        //Se a rodada foi finalizada, vai para a proxima
        if (scriptDoObjetoDaRodadaAtual != null)
        {
            if (scriptDoObjetoDaRodadaAtual.getEncaixou())
            {
                flag = true;
                scriptDoObjetoDaRodadaAtual = null;
            }
        }
    }

    private void ativarDica()
    {
        tempo += Time.deltaTime;

        if (tempo > 0.65)
        {
            if (dicaLigadoDesligado)
            {
                for (int i = 0; i < transform.childCount; i++)
                {
                    transform.GetChild(i).gameObject.transform.GetChild(1).gameObject.SetActive(true);
                }
                dicaLigadoDesligado = false;
            }
            else
            {
                for (int i = 0; i < transform.childCount; i++)
                {
                    transform.GetChild(i).gameObject.transform.GetChild(1).gameObject.SetActive(false);
                }
                dicaLigadoDesligado = true;
            }

            tempo = 0;
        }
    }

    private void instanciarEncaixes(string proxCombinacao)
    {
        GameObject objAtual;
        if (proxCombinacao == "Triângulo")
        {
            objAtual = Instantiate(encaixeTriangulo, posicoes[rodada], Quaternion.identity, transform);
            scriptDoObjetoDaRodadaAtual = objAtual.GetComponent<Encaixe_obj>();
            instanciarAlternativa(triangulo);
        }
        else
        {
            if (proxCombinacao == "Quadrado")
            {
                objAtual = Instantiate(encaixeQuadrado, posicoes[rodada], Quaternion.identity, transform);
                scriptDoObjetoDaRodadaAtual = objAtual.GetComponent<Encaixe_obj>();
                instanciarAlternativa(quadrado);
            }
            else
            {
                if (proxCombinacao == "Estrela")
                {
                    objAtual = Instantiate(encaixeEstrela, posicoes[rodada], Quaternion.identity, transform);
                    scriptDoObjetoDaRodadaAtual = objAtual.GetComponent<Encaixe_obj>();
                    instanciarAlternativa(estrela);
                }
            }
        }
    }

    private void instanciarAlternativa(GameObject opcaoCorreta)
    {
        List<GameObject> alternativa = new List<GameObject>();

        alternativa.Add(opcaoCorreta);
        alternativa.Add(solidos[randon.Next(solidos.Count)]);
        alternativa.Add(solidos[randon.Next(solidos.Count)]);

        List<GameObject> alternativaEmbaralhada = alternativa.OrderBy(item => randon.Next()).ToList();

        Instantiate(alternativaEmbaralhada[0], posicoes[rodada] + new Vector3(5f,5f,10f), Quaternion.identity, objetosInteragiveis.transform);
        Instantiate(alternativaEmbaralhada[1], posicoes[rodada] + new Vector3(0f,5f,10f), Quaternion.identity, objetosInteragiveis.transform);
        Instantiate(alternativaEmbaralhada[2], posicoes[rodada] + new Vector3(-5f,5f,10f), Quaternion.identity, objetosInteragiveis.transform);

    }



}
