using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.InputSystem.Controls;
using UnityEngine.Timeline;

public class Encaixe_obj : MonoBehaviour
{

    public GameObject objetosInteragiveis;
    public GameObject alvo;

    private bool encaixou = false;

    [SerializeField] int id;
    [SerializeField] AudioClip acertou; bool flagAcertou=false;
    [SerializeField] AudioClip errou; bool flagErrou=false;
    private AudioSource audioS;
    float tempo=0;



    void Start()
    {
        objetosInteragiveis = GameObject.Find("Objetos Interagiveis");
        alvo = transform.GetChild(1).gameObject;
        audioS = GetComponent<AudioSource>();
    }

    void Update()
    {

        for (int i = 0; i < objetosInteragiveis.transform.childCount; i++)
        {
            GameObject game_obj = objetosInteragiveis.transform.GetChild(i).gameObject;
            float distancia = UnityEngine.Vector3.Distance(game_obj.transform.position, alvo.transform.position);
            Solidos_obj script_obj = game_obj.GetComponent<Solidos_obj>();
            string nomeObj = game_obj.name;

            if (distancia < 2 && script_obj.getPegou() == false)
            {
                if (id == script_obj.getId())
                {
                    script_obj.setEncaixado(true);
                    transladaOBJ(game_obj);
                }
                else
                {
                    if (!flagErrou)
                    {
                        audioS.PlayOneShot(errou);
                        flagErrou = true;
                    }
                }
            }

        }

        tempo += Time.deltaTime;
        if (tempo > 2)
        {
            flagErrou = false;
            tempo = 0;
        }

    }

    private void transladaOBJ(GameObject obj)
    {

        Vector3 direcao = alvo.transform.position - obj.transform.position;
        Rigidbody rigidbody = obj.GetComponent<Rigidbody>();
        Collider collider = rigidbody.GetComponent<Collider>();

        if (Vector3.Distance(alvo.transform.position, obj.transform.position) > 0.1)
        {
            rigidbody.constraints = rigidbody.constraints | RigidbodyConstraints.FreezeRotation;
            collider.enabled = false;
            direcao.Normalize();
            rigidbody.velocity = direcao * 2.0f;
            obj.transform.rotation = Quaternion.Euler(0, 0, 0);

        }
        else
        {
            rigidbody.constraints = rigidbody.constraints | RigidbodyConstraints.FreezeAll;
            encaixou = true;
            if (!flagAcertou)
            {
                audioS.PlayOneShot(acertou);
                flagAcertou = true;
            }
        }


    }

    public bool getEncaixou()
    {
        return encaixou;
    }

}
