using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.InputSystem;

public class Movimento : MonoBehaviour
{

    private Vector2 EntradaAnalogico;
    [SerializeField] float velocidade = 5;
    [SerializeField] Rigidbody controlador;
    bool EstaMovendo = false;
    private Animator animacao;


    // Start is called before the first frame update
    void Start()
    {
        if (controlador == null)
        {
            controlador = GetComponent<Rigidbody>();
        }
        animacao = GetComponentInChildren<Animator>();

    }

    // Update is called once per frame
    void Update()
    {
            movimento();
    }

    void movimento(){

        float magnetude = EntradaAnalogico.magnitude;
        
        Vector3 direcaoEntrada = new Vector3(EntradaAnalogico.x, 0, EntradaAnalogico.y).normalized;

        if (direcaoEntrada != Vector3.zero){
            Vector3 movimentoDesejado = transform.TransformDirection(direcaoEntrada*magnetude) * velocidade;

            Vector3 novaVelocidade = new Vector3(movimentoDesejado.x, controlador.velocity.y, movimentoDesejado.z);
            controlador.velocity = novaVelocidade;
        }else{
            controlador.velocity = new Vector3(0, controlador.velocity.y, 0);
        }

        
    }

    public bool getEstaMovendo()
    {
        return EstaMovendo;
    }

    public void MoverPersonagem(InputAction.CallbackContext value)
    {
        if (value.started)
        {
            EstaMovendo = true;
            animacao.SetBool("movimentando", true);
        }

        if (value.canceled)
        {
            EstaMovendo = false;
            animacao.SetBool("movimentando", false);
        }  


        EntradaAnalogico = value.ReadValue<Vector2>();
    }

   

}
