using System.Collections;
using System.Collections.Generic;
using System.Numerics;
using Unity.VisualScripting;
using UnityEngine;
using UnityEngine.InputSystem;
using UnityEngine.UIElements;

public class Pegar : MonoBehaviour
{

    private bool pegar = false;
    private List<GameObject> objetosPerto = new List<GameObject>();
    private GameObject objetoMaisPerto;
    private new Rigidbody rigidbody = null;
    public GameObject objetosInteragiveis;
    public GameObject UI_pegar;
    public GameObject mira;

    // Start is called before the first frame update
    void Start()
    {
        mira = GameObject.Find("Mira");
        UI_pegar = GameObject.Find("Pegar");
        UI_pegar.SetActive(false);



    }

    // Update is called once per frame
    void Update()
    {
        verificaSolidosPerto();
        if (pegar)
        {
            transladaOBJ();
        }
    }

    public void pegarObjeto(InputAction.CallbackContext valor)
    {
        if (valor.performed)
        {
            if (!pegar)
            {
                objetoMaisPerto = objetosPerto[0];
                for (int i = 0; i < objetosPerto.Count; i++)
                {
                    if (UnityEngine.Vector3.Distance(objetosPerto[i].transform.position, transform.position) < UnityEngine.Vector3.Distance(objetoMaisPerto.transform.position, transform.position))
                    {
                        objetoMaisPerto = objetosPerto[i];
                    }
                }
                Solidos_obj obj = objetoMaisPerto.GetComponent<Solidos_obj>();
                obj.setPegou(true);
                pegar = true;
                rigidbody = objetoMaisPerto.transform.GetComponent<Rigidbody>();
                rigidbody.useGravity = false;
            }
            else
            {
                Solidos_obj obj = objetoMaisPerto.GetComponent<Solidos_obj>();
                obj.setPegou(false);
                rigidbody.constraints = RigidbodyConstraints.None;
                
                rigidbody.useGravity = true;
                objetoMaisPerto = null;
                pegar = false;
            }
        }
    }

    private void verificaSolidosPerto()
    {
        for (int i = 0; i < objetosInteragiveis.transform.childCount; i++)
        {
            float distancia = UnityEngine.Vector3.Distance(objetosInteragiveis.transform.GetChild(i).gameObject.transform.position, transform.position);
            Solidos_obj solidos_Obj = objetosInteragiveis.transform.GetChild(i).gameObject.GetComponent<Solidos_obj>();

            if (distancia < 7)
            {
                if (!solidos_Obj.getAlguemPerto() && !solidos_Obj.getEncaixado())
                {
                    solidos_Obj.setAlguemPerto(true);
                    objetosPerto.Add(objetosInteragiveis.transform.GetChild(i).gameObject);

                }
                UI_pegar.SetActive(true);


            }
            else
            {
                if (solidos_Obj.getAlguemPerto())
                {
                    solidos_Obj.setAlguemPerto(false);
                    

                }
                objetosPerto.Remove(objetosInteragiveis.transform.GetChild(i).gameObject);
            }

            if (objetosPerto.Count == 0)
            {
                UI_pegar.SetActive(false);

            }


            
        }
    }


    private void transladaOBJ()
    {

        UnityEngine.Vector3 direcao = mira.transform.position - objetoMaisPerto.transform.position;


        if (UnityEngine.Vector3.Distance(mira.transform.position, objetoMaisPerto.transform.position) > 0.3f)
        {
            rigidbody.constraints = RigidbodyConstraints.None;
            direcao.Normalize();
            rigidbody.velocity = direcao * 10.0f;
        }
        else
        {
            rigidbody.constraints = rigidbody.constraints | RigidbodyConstraints.FreezeAll;

        }

    }


}

