using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.InputSystem;

public class Rotacao : MonoBehaviour
{

    private Vector2 entradaRotacao;
    [SerializeField] float sensibilidade = 0.1f;
    private float rotacaoX = 0;
    [SerializeField] Camera camer;
  



    // Start is called before the first frame update
    void Start()
    {
        if (camer == null)
            camer = GetComponentInChildren<Camera>();

    }

    // Update is called once per frame
    void Update()
    {
        rotacao();
    }

    void rotacao(){
        

        float coordX = entradaRotacao.x * sensibilidade;
        float coordY = entradaRotacao.y * sensibilidade;

        transform.Rotate(Vector3.up * coordX);

        rotacaoX -= coordY;
        rotacaoX = Mathf.Clamp(rotacaoX, -180, 0f); 
        camer.transform.localRotation = Quaternion.Euler(rotacaoX, 90f, 0f);

    }

    public void Rotacionar(InputAction.CallbackContext context){

         entradaRotacao = context.ReadValue<Vector2>();

    }
}
