import 'package:flutter/material.dart';
import 'package:sizer/sizer.dart';
import 'package:auto_size_text/auto_size_text.dart';
import 'package:fading_edge_scrollview/fading_edge_scrollview.dart';

class InstructionsScreen extends StatelessWidget {
  const InstructionsScreen({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: SafeArea(
        child: Padding(
          padding: EdgeInsets.all(24.0),

          child: Column(
            children: <Widget>[
              AutoSizeText(
                'Instruções',
                style: TextStyle(fontSize: 20.sp, fontWeight: FontWeight.bold),
                textAlign: TextAlign.center,
                maxLines: 1,
              ),

              SizedBox(height: 20),

              Expanded(child: _buildMainContent(context)),
            ],
          ),
        ),
      ),
    );
  }

  Widget _buildMainContent(BuildContext context) {
    final scrollController = ScrollController();

    final defaultStyle = TextStyle(fontSize: 17.sp);
    final boldStyle = TextStyle(fontWeight: FontWeight.bold);
    final sectionTitleStyle = TextStyle(
      fontSize: 19.sp,
      fontWeight: FontWeight.bold,
      color: Theme.of(context).colorScheme.primary,
    );
    final commentStyle = TextStyle(
      fontSize: 16.sp,
      fontStyle: FontStyle.italic,
      color: Colors.grey.shade700,
    );

    return Scrollbar(
      thickness: 4.0,
      radius: Radius.circular(8.0),

      child: FadingEdgeScrollView.fromSingleChildScrollView(
        child: SingleChildScrollView(
          padding: EdgeInsets.symmetric(horizontal: 5.0),
          controller: scrollController,

          child: Column(
            children: <Widget>[
              // Parágrafo introdutório
              AutoSizeText.rich(
                style: defaultStyle,
                textAlign: TextAlign.justify,

                TextSpan(
                  children: <TextSpan>[
                    TextSpan(
                      text:
                          'O Puxa-Conversa é um jogo diferente e sem regras, com perguntas abertas que visam estimular conversas em torno do tema: ',
                    ),
                    TextSpan(
                      text: 'envelhecimento humano e qualidade de vida',
                      style: boldStyle,
                    ),
                    TextSpan(text: '.\n'),
                  ],
                ),
              ),

              // Seção de orientações
              AutoSizeText(
                'Como jogar\n',
                style: sectionTitleStyle,
                textAlign: TextAlign.center,
              ),
              AutoSizeText.rich(
                style: defaultStyle,
                textAlign: TextAlign.justify,

                TextSpan(
                  children: <TextSpan>[
                    TextSpan(text: '1. ', style: boldStyle),
                    TextSpan(text: 'No menu principal, clique em '),
                    TextSpan(text: 'Jogar', style: boldStyle),
                    TextSpan(text: '.\n\n'),

                    TextSpan(text: '2. ', style: boldStyle),
                    TextSpan(
                      text:
                          'Selecione as categorias de perguntas sobre as quais deseja conversar e clique em ',
                    ),
                    TextSpan(text: 'Começar', style: boldStyle),
                    TextSpan(text: '.\n'),
                    TextSpan(
                      text:
                          'Você pode selecionar "Todas as categorias" para um jogo com todo tipo de pergunta ou "Personalizar" para escolher temas específicos.\n\n',
                      style: commentStyle,
                    ),

                    TextSpan(text: '3. ', style: boldStyle),
                    TextSpan(
                      text:
                          'Pense nas perguntas como uma pilha de cartas: ao arrastar uma carta, outra pergunta aparece!\n',
                    ),
                    TextSpan(
                      text:
                          'Você também pode voltar para perguntas anteriores ou encerrar o jogo a qualquer momento.\n',
                      style: commentStyle,
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
